/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.remconsq;

import com.ibm.hwmca.fw.connserv.CommPath;
import com.ibm.hwmca.fw.connserv.PathRequestInfo;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class CommPathInfo
implements Serializable {
    private static final String LO_PRIORITY = "Low";
    private static final String ME_PRIORITY = "Medium";
    private static final String HI_PRIORITY = "High";
    private int id;
    private int state;
    private String system;
    private String priority;
    private Date date;
    private String description;

    public CommPathInfo(int id, int state, String system, int priority, Date date, String description) {
        this.id = id;
        this.state = state;
        this.system = system;
        this.priority = this.convertPriority(priority);
        this.date = date;
        this.description = description;
    }

    public CommPathInfo(int id, int state, String system, Date date, String description) {
        this(id, state, system, -1, date, description);
    }

    public CommPathInfo(CommPath commPath) {
        this(commPath.getId(), commPath.getState(), commPath.getRequestInfo().getOriginationSystem(), commPath.getPriority(), commPath.getRequestInfo().getOriginationTime(), commPath.getRequestInfo().getDescription().toString());
    }

    public CommPathInfo() {
        this(-1, -1, null, -1, null, null);
    }

    public void setInfo(CommPath commPath) {
        PathRequestInfo info = commPath.getRequestInfo();
        this.id = commPath.getId();
        this.state = commPath.getState();
        this.system = info.getOriginationSystem();
        this.priority = this.convertPriority(commPath.getPriority());
        this.date = info.getOriginationTime();
        this.description = info.getDescription().toString();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = this.convertPriority(priority);
    }

    public Calendar getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date);
        return calendar;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("com.ibm.hwmca.base.remconsq.CommPathInfo( ");
        str.append("ID=" + this.getId() + " , ");
        str.append("State=" + this.getState() + " , ");
        str.append("System=" + this.getSystem() + " , ");
        str.append("Priority=" + this.getPriority() + " , ");
        str.append("Date=" + this.getDate().toString() + " , ");
        str.append("Description=" + this.getDescription() + " )");
        return str.toString();
    }

    private String convertPriority(int priority) {
        switch (priority) {
            case 0: {
                return LO_PRIORITY;
            }
            case 1: {
                return ME_PRIORITY;
            }
            case 2: {
                return HI_PRIORITY;
            }
        }
        return null;
    }
}

